import axios from "@/lib/axios"
import { Video } from "@/types/Video";

export const csrf = () => axios.get('/sanctum/csrf-cookie')

export const getVideos = async () => {
    return await axios.get("/api/v1/admin/videos").then((res) => res.data.videos)
}

export const getVideo = async (id: number) => {
    return await axios.get(`/api/v1/admin/videos/${id}`).then((res) => res.data)
}

export const updateVideo = async (id: number, data: Video) => {
    return await axios.put(`/api/v1/admin/videos/${id}`, data).then((res) => res.data)
}

// export const uploadVideo = async (file: any) => {
//     await csrf()

//     const formData = new FormData();
//     formData.append('file', file.data);

//     return await axios.post("/api/v1/admin/videos", formData, {
//         headers: {
//             'Content-Type': 'multipart/form-data',
//         }
//     }).then((res) => res.data)
// }

export const deleteVideo = async (id: number) => {
    return await axios.delete(`/api/v1/admin/videos/${id}`).then((res) => res.data)
}

// Frontend apis
export const getAllVideos = async () => {
    return await axios.get("/api/v1/videos?type=all").then((res) => res.data.videos)
}

export const getVideosByWatchId = async (watch_id: string) => {
    return await axios.get(`/api/v1/videos/watch/${watch_id}`).then((res) => res.data)
}