import { useEffect, useRef, useCallback } from "react";
// import Plyr from 'plyr';
import 'plyr/dist/plyr.css';
import dynamic from "next/dynamic";

const shaka = dynamic(() => import("shaka-player/dist/shaka-player.compiled.js", { ssl: false }));

const ShakaPlayer = (props) => {
  const { manifestUri, posterUrl } = props;

  const licenseServer = "https://proxy.uat.widevine.com/proxy";

  const videoContainer = useRef(null);
  const video = useRef(null);

  const initPlayer = useCallback(async () => {
    // new Plyr(video.current, {
    //   debug: true,
    // });

    let shakaInstance = new shaka.Player();

    await shakaInstance.attach(video.current);

    shakaInstance.configure({
      drm: {
        servers: { "com.widevine.alpha": licenseServer },
      },
    });

    const onError = (error) => {
      // Log the error.
      console.error("Error code", error.code, "object", error);
    };

    const onErrorEvent = (event) => {
      // Extract the shaka.util.Error object from the event.
      onError(event.detail);
    };

    shakaInstance.addEventListener("error", onErrorEvent);

    if(manifestUri) {
        // Try to load a manifest.
        // This is an asynchronous process.
        try {
          await shakaInstance.load(manifestUri);
          // This runs if the asynchronous load is successful.
          console.log("The video has now been loaded!");
        } catch (e) {
          console.log("load error");
          // onError is executed if the asynchronous load fails.
          onError(e);
        }
      
    }
  }, [manifestUri, licenseServer]);

  useEffect(() => {
    shaka.polyfill.installAll();

    if(shaka.Player.isBrowserSupported()) {
      initPlayer();
    } else {
      console.log('shaka player not supported')
    }
  }, [manifestUri]);

  return (
    <div
      className="shadow-lg mx-auto max-w-full"
      ref={videoContainer}
      style={{ width: "800px" }}
    >
      <video
        id="video"
        ref={video}
        className="w-full h-full"
        poster={posterUrl}
        controls autoPlay
        crossOrigin="anonymous"
        playsInline
      ></video>
    </div>
  );
};

export default ShakaPlayer;
