'use client'

import ShakaPlayer from '@/components/shaka-player';
import { getVideosByWatchId } from '@/services/video';
import { Video } from '@/types/Video';
import { useSearchParams } from 'next/navigation'
import { Suspense, useEffect, useState } from 'react';

const ShakaPlayerView = () => {
    const searchParams = useSearchParams()

    const watch_id = searchParams.get('_vl');
    const [video, setVideo] = useState<Video | null>(null)

    useEffect(() => {
        if(watch_id) {
            getVideosByWatchId(watch_id).then((res) => {
                setVideo(res.video)
            })
        }
    }, [watch_id])

    return <ShakaPlayer manifestUri={video?.video_url} posterUrl={video?.poster} />
}

const WatchPage = () => {
    return (
        <div className="container mx-auto my-3">
            <Suspense><ShakaPlayerView /></Suspense>
        </div>
    )
}

export default WatchPage;