'use client'

import { PowerIcon } from '@heroicons/react/24/outline';
import { useAuth } from '@/hooks/auth';

const LogoutForm = () => {

    const { logout, user } = useAuth({
        middleware: 'auth',
        redirectIfAuthenticated: '/dashboard',
    })
    
    const logoutApp = async (event: React.FormEvent) => {
        event.preventDefault()

        logout()
    }

    return (
        <>
            <form onSubmit={logoutApp}>
            <p className="flex h-[48px] grow gap-2 rounded-md bg-gray-50 p-3 text-sm font-medium">User: {user?.name}</p>
              <button className="flex h-[48px] w-full grow items-center justify-center gap-2 rounded-md bg-gray-50 p-3 text-sm font-medium hover:bg-sky-100 hover:text-blue-600 md:flex-none md:justify-start md:p-2 md:px-3">
                <PowerIcon className="w-6" />
                <div className="hidden md:block">Sign Out</div>
              </button>
            </form>
        </>
    )
}

export default LogoutForm


