'use client'

import AcmeLogo from "@/app/ui/acme-logo";
import { useSearchParams } from "next/navigation";
import Link from "next/link";
import { Suspense } from "react";

const Reference = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('ref');

    return (
        <strong>{reference}</strong>
    );
};

const PaymentConfirmation = () => {

    return (
        <main className="flex min-h-screen flex-col p-6">
            <div className="flex h-20 shrink-0 items-end rounded-lg bg-blue-500 p-4 md:h-30">
                <AcmeLogo />
            </div>
            <div className="mt-5 w-2/3 mx-auto bg-blue-950 text-white p-3 text-center">
                <h2 className="text-2xl">Payment Successful</h2>
                <div className="mt-5">
                    Thanks for your purchase! Your payment reference is <Suspense><Reference /></Suspense>
                    <div className="mt-4"><Link className="mt-4" href="/">Make another payment</Link></div>
                </div>
            </div>
        </main>
    );
};

export default PaymentConfirmation;